;;
;;
;;  movebak.lsp - MOVEBAK command
;;
;;  Copyright  1999 by Autodesk, Inc.
;;
;;  Your use of this software is governed by the terms and conditions
;;  of the License Agreement you accepted prior to installation of this
;;  software.  Please note that pursuant to the License Agreement for this
;;  software, "[c]opying of this computer program or its documentation
;;  except as permitted by this License is copyright infringement under
;;  the laws of your country.  If you copy this computer program without
;;  permission of Autodesk, you are violating the law."
;;
;;  AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.  AUTODESK
;;  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR
;;  FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.  DOES NOT WARRANT THAT
;;  THE OPERATION OF THE PROGRAM WILL BE UNINTERRUPTED OR ERROR FREE.
;;
;;  Use, duplication, or disclosure by the U.S. Government is subject to
;;  restrictions set forth in FAR 52.227-19 (Commercial Computer Software -
;;  Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) (Rights in Technical
;;  Data and Computer Software), as applicable.
;;
;;----------------------------------------------------------------
;;
;;  DESCRIPTION
;;  Provides an interface to the MOVEBAK ObjectARX app.
;;
;;----------------------------------------------------------------
 
 
(defun C:MOVEBAK (/ cur new)
  (acet-error-init nil)
  (if (member nil (mapcar
        '(lambda (x) (if (member x (arx)) T (arxload x nil)))
           '("acetutil.arx") ) )
    (alert "Could not load required ObjectARX modules.")
    (progn
      (setq cur (getenv "AcetMovebak")
            cur (if cur cur "")
            new (getstring T
                    (acet-str-format
                        "New value for MOVEBAK, or . for none <%1>: " cur ) )
            new (cond
                  ((= "" new) cur)
                  ((= "~" new) (acet-ui-pickdir
                                 "Select MOVEBAK directory" cur ) )
                  ((= "." new) "")
                  (T new)
                )
      )
      (if new
        (setq new (acet-str-replace "/" "\\" new)) )
      (if (and new
               (/= "" new)
               (/= ":\\" (substr new 2))
               (/= Acet:DIRECTORY (acet-file-attr new)) )
        (progn
          (princ (acet-str-format "Not a directory: %1" new))
          (setq new nil)
        )
      )
 
      (if new
        (setenv "AcetMoveBak" new) )
    )
  )
  (acet-error-restore)
  (princ)
)
 
;;  verify 'acetutil.fas'
(if (and (not acet-error-init) (not (load "acetutil" nil)))
  (progn
    (princ "Missing 'acetutil.fas', MOVEBAK not loaded.")
    (setq C:MOVEBAK nil)
  )
  (princ "MOVEBAK command loaded.")
)


(princ)

;;;-----BEGIN-SIGNATURE-----
;;; aAcAADCCB2QGCSqGSIb3DQEHAqCCB1UwggdRAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIFBjCCBQIwggPqoAMCAQICEGS8scfO5NpYadWPHiL76fQw
;;; DQYJKoZIhvcNAQELBQAwfzELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVj
;;; IENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTAw
;;; LgYDVQQDEydTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBDb2RlIFNpZ25pbmcgQ0Ew
;;; HhcNMTUwOTAzMDAwMDAwWhcNMTYwOTAyMjM1OTU5WjCBiDELMAkGA1UEBhMCVVMx
;;; EzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwxFjAUBgNV
;;; BAoMDUF1dG9kZXNrLCBJbmMxHzAdBgNVBAsMFkRlc2lnbiBTb2x1dGlvbnMgR3Jv
;;; dXAxFjAUBgNVBAMMDUF1dG9kZXNrLCBJbmMwggEiMA0GCSqGSIb3DQEBAQUAA4IB
;;; DwAwggEKAoIBAQDqmfToz8wEanfXT+H6tql3aUyaJRWCfFsYPFnGVXIl95fnZY3s
;;; OEfQvFkf9LVte5SwDWkjkReCGJlk4HaRYOTxkd7PkeAOOtYaUSBvULYRlKvAbe2n
;;; +VWwo4yrWATav8d7pKlbMP9f6pYxlaZQzsq/e+pLZwptP8C9Dfrm5OVgCIL/iPRN
;;; Iuvhl9YUZvnkZYmCnihdP4AS8g4d7rfjdxzT653433nO6tgs3fNgnkQQk6EdROwq
;;; esgQXRlH29yRND5xNfup9KiZ7L7Nm7AiM6laNwNIjBwbG4qMWuQ2Ml7hHzQpLaLF
;;; JRV33oHedeGSZ7OmA6+D5WoQtPpSt4YCcub5AgMBAAGjggFuMIIBajAJBgNVHRME
;;; AjAAMA4GA1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzBmBgNVHSAE
;;; XzBdMFsGC2CGSAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5zeW1j
;;; Yi5jb20vY3BzMCUGCCsGAQUFBwICMBkaF2h0dHBzOi8vZC5zeW1jYi5jb20vcnBh
;;; MB8GA1UdIwQYMBaAFJY7U/B5M5evfYPvLivMyreGHnJmMCsGA1UdHwQkMCIwIKAe
;;; oByGGmh0dHA6Ly9zdi5zeW1jYi5jb20vc3YuY3JsMFcGCCsGAQUFBwEBBEswSTAf
;;; BggrBgEFBQcwAYYTaHR0cDovL3N2LnN5bWNkLmNvbTAmBggrBgEFBQcwAoYaaHR0
;;; cDovL3N2LnN5bWNiLmNvbS9zdi5jcnQwEQYJYIZIAYb4QgEBBAQDAgQQMBYGCisG
;;; AQQBgjcCARsECDAGAQEAAQH/MA0GCSqGSIb3DQEBCwUAA4IBAQAegWHWPJ8y1kt5
;;; 7JP8TOQlnYs0eMMg5/MHxlW3LhKv/PG8jZ2NDg8YrGuwBC7y3um+PA6KxRT9px8N
;;; KjniMX4NsPtQ81s2EITHy4uFfz6dTpgmL2BLE2/6FPmG4koEhY6zeT4tizeTscOR
;;; Mu1gCtr4Vq+BC/+0Ax6LKOGt5Ut1pJT89ivzZYZOIvEtt9AZRgh7GRg2Oz7X6MFn
;;; c3KudMQhCEnBEUkbS3fmC+kll5PuoF/R1XBcbby0ODfQ3xfwSpNd6WIMr2T5HnSC
;;; gOMmAsuP1Y6LjaCoYDP2mhiwMg797o0XVywnKLEeDGw/F9b/c+lpIBuWGWYnFjz7
;;; CTe7cgdcMYICIjCCAh4CAQEwgZMwfzELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
;;; bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3
;;; b3JrMTAwLgYDVQQDEydTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBDb2RlIFNpZ25p
;;; bmcgQ0ECEGS8scfO5NpYadWPHiL76fQwDQYJKoZIhvcNAQELBQAwDQYJKoZIhvcN
;;; AQEBBQAEggEAE4uKUY1sNpjH1axeYkHr71iE+B/AexFXhY3Ejqs1aL046NPPmCjP
;;; etegvQ4HFaSL3/SCziwmjAq/mkazVppfyuFUJCTw0cEqpS7p7t9yEPWAMo5hd7wn
;;; AK4IXvzEhEcWxK0/2Cay/wOMGHUQ5qM8H57Polv7dKdj17dBHQFMa3qGF12ArI1l
;;; xXyb3YHSnA/LKFUgU+O8TUspc323jEGj9NC3h6n2TTzCmY/urbsVDdJNH7b9lyNs
;;; hW/DgbF4LvWEm1i6n9SDfXclh/MY1KWK9VBv2AsJpBe2GnF98ulqHSNra6S6ERvc
;;; CY2kefGwdODbBW2giWSlj9TUdDgO0DQjUaFhMF8GA1UdDjFYBFYzADkAOwAyAC8A
;;; NwAvADIAMAAxADYALwA1AC8AOQAvADUAMwAvAFQAaQBtAGUAIABmAHIAbwBtACAA
;;; dABoAGkAcwAgAGMAbwBtAHAAdQB0AGUAcgAAAA==
;;; -----END-SIGNATURE-----